import cv2
import face_recognition
from gtts import gTTS
import os

# Kayıtlı kişileri ve yüz kodlarını saklayacak bir sözlük oluşturun
kayitli_kisiler = {
    "İsmail Cem Avcı": face_recognition.face_encodings(face_recognition.load_image_file("/Users/cemavci/PycharmProjects/yuz_tanima/veritabani/İsmailCemAvci/CemAvci.png"))[0],
    "Güzide Nur Avcı": face_recognition.face_encodings(face_recognition.load_image_file("/Users/cemavci/PycharmProjects/yuz_tanima/veritabani/İsmailCemAvci/guz.png"))[0]
}

video_kaynagi = cv2.VideoCapture(0)
sayac=0
while sayac==0:
    ret, cerceve = video_kaynagi.read()
    yuzler = face_recognition.face_locations(cerceve)
    yuz_kodlari = face_recognition.face_encodings(cerceve, yuzler)

    for yuz_kodu, yuz_konumu in zip(yuz_kodlari, yuzler):
        for isim, kayitli_yuz_kodlari in kayitli_kisiler.items():
            eslesme = face_recognition.compare_faces([kayitli_yuz_kodlari], yuz_kodu)
            mesafe = face_recognition.face_distance([kayitli_yuz_kodlari], yuz_kodu)

            if eslesme[0]:
                y1, x2, y2, x1 = yuz_konumu
                cv2.rectangle(cerceve, (x1, y1), (x2, y2), (0, 255, 0), 2)
                cv2.putText(cerceve, isim, (x1, y2 + 20), cv2.FONT_HERSHEY_SIMPLEX, 0.8, (0, 255, 0), 2)
                cv2.imshow("Yüz Tanıma", cerceve)

                # Sesli komutu bir dosyaya kaydet
                tts = gTTS(text=f"Karşında {isim} adlı kişiyi tespit ettim. Başka ne yapmamı istersin?", lang='tr')
                tts.save("komut.mp3")

                # Sesli komutu çal
                os.system("afplay komut.mp3")  # macOS için çalma komutu
                os.remove("komut.mp3")  # Dosyayı sil

                # Döngüyü sonlandır
                sayac+=1

# Kamerayı kapat
video_kaynagi.release()
cv2.destroyAllWindows()
